#ifndef VLTOOLS_H
#define VLTOOLS_H

#ifndef _WINDOWS_
#include <windows.h>
#endif
#ifndef _INC_STDIO
#include <stdio.h>
#endif
#ifndef VERCHECK_HH
#include <VersionCheck.h>
#endif
#ifndef _LIST_
#include <list>
#endif

//////////////////////////////////////////////////////////////////////////////////////////
// Macros
/////////

// Mark the beginning of an encrypted function, and setup calls to decrypt it.
//#ifndef _DEBUG
#ifndef NO_ENCRYPT

#define ENCRYPT_START char *ENCRYPT_THISFUNCTION_ADDRESS; __asm { call ENCRYPT_START_label __asm ENCRYPT_START_label: pop eax __asm mov ENCRYPT_THISFUNCTION_ADDRESS, eax } decryptfunction(ENCRYPT_THISFUNCTION_ADDRESS); __asm { nop __asm sub esp, 0x01 __asm add esp, 0x01 __asm nop }
#define ENCRYPT_START_NAMED(label) char *ENCRYPT_THISFUNCTION_ADDRESS; __asm { call label __asm label: pop eax __asm mov ENCRYPT_THISFUNCTION_ADDRESS, eax } decryptfunction(ENCRYPT_THISFUNCTION_ADDRESS); __asm { nop __asm sub esp, 0x01 __asm add esp, 0x01 __asm nop }
#define SCRAMBLE_START char *SCRAMBLE_THISFUNCTION_ADDRESS; __asm { call SCRAMBLE_START_label __asm SCRAMBLE_START_label: pop eax __asm mov SCRAMBLE_THISFUNCTION_ADDRESS, eax } descramblefunction(SCRAMBLE_THISFUNCTION_ADDRESS); __asm { nop __asm sub esp, 0x09 __asm add esp, 0x09 __asm nop }
#define SCRAMBLE_START_NAMED(label) char *SCRAMBLE_THISFUNCTION_ADDRESS; __asm { call label __asm label: pop eax __asm mov SCRAMBLE_THISFUNCTION_ADDRESS, eax } descramblefunction(SCRAMBLE_THISFUNCTION_ADDRESS); __asm { nop __asm sub esp, 0x09 __asm add esp, 0x09 __asm nop }
//#else
//#define ENCRYPT_START char *ENCRYPT_THISFUNCTION_ADDRESS; __asm { call label __asm label: pop eax __asm mov ENCRYPT_THISFUNCTION_ADDRESS, eax } encryptfunction(ENCRYPT_THISFUNCTION_ADDRESS); decryptfunction(ENCRYPT_THISFUNCTION_ADDRESS); __asm { nop __asm sub esp, 0x01 __asm add esp, 0x01 __asm nop }
//#endif

// Mark the end of an encrypted function, and setup the calls to re-encrypt it
//#ifndef _DEBUG
#define ENCRYPT_END __asm { __asm nop __asm sub esp, 0x03 __asm add esp, 0x03 __asm nop } encryptfunction(ENCRYPT_THISFUNCTION_ADDRESS);
#define SCRAMBLE_END __asm { __asm nop __asm sub esp, 0x0b __asm add esp, 0x0b __asm nop } scramblefunction(SCRAMBLE_THISFUNCTION_ADDRESS);
//#else
//#define ENCRYPT_END __asm { __asm nop __asm sub esp, 0x03 __asm add esp, 0x03 __asm nop } encryptfunction(ENCRYPT_THISFUNCTION_ADDRESS); decryptfunction(ENCRYPT_THISFUNCTION_ADDRESS);
//#endif

// Mark the beginning of an encrypted function, without decrypting it
#define ENCRYPT_START_TAGONLY __asm { nop __asm sub esp, 0x01 __asm add esp, 0x01 __asm nop }
#define SCRAMBLE_START_TAGONLY __asm { nop __asm sub esp, 0x09 __asm add esp, 0x09 __asm nop }

// Mark the end of an encrypted function, without re-encrypting it
#define ENCRYPT_END_TAGONLY __asm { __asm nop __asm sub esp, 0x03 __asm add esp, 0x03 __asm nop }
#define SCRAMBLE_END_TAGONLY __asm { __asm nop __asm sub esp, 0x0b __asm add esp, 0x0b __asm nop }

// Initialize the run-time encryption system
#define INITENCRYPT { *encryptstartsignature = *encryptendsignature = 0x90; decryptfunction(encryptfunction); }
#define INITSECUREENCRYPT(val) { *encryptstartsignature = *encryptendsignature = (char)0x90; checksum = val; decryptfunction(encryptfunction); }
#define INITSCRAMBLE { scramblestartsignature[0] = scrambleendsignature[0] = '\x90'; descramblefunction(scramblefunction); }
//#define INITENCRYPT { encryptstartsignature[0] = encryptendsignature[0] = 0x90; }

#define GetProcedureAddress EGetProcedureAddress

#else

#define GetProcedureAddress UEGetProcedureAddress

#endif

#ifndef _DEBUG
#pragma comment(linker, "/RELEASE")
#pragma comment(linker, "/OPT:NOWIN98")

#if defined(_MERGE_SECTIONS_) || defined(_MERGE_RDATA_)
#pragma comment(linker,"/merge:.rdata=.data")
#endif

#if defined(_MERGE_SECTIONS_) || defined(_MERGE_TEXT_)
#pragma comment(linker,"/merge:.text=.data")
#endif

#if defined(_MERGE_SECTIONS_) || defined(_MERGE_RELOC_)
#pragma comment(linker,"/merge:.reloc=.data")
#endif

#if defined(_MERGE_SECTIONS_) || defined(_MERGE_RSRC_)
#pragma comment(linker, "/merge:.rsrc=.data")
#endif

// Merging sections with different attributes causes a linker warning, so
// turn off the warning. From Michael Geary. Undocumented, as usual!
#pragma comment(linker,"/ignore:4078")

#ifndef NO_OPTIMIZE
#pragma optimize("gsy", on)
#endif
#endif

//////////////////////////////////////////////////////////////////////////////////////////
// Functions
////////////

// Forward declarations
class LadderQuery;
class LadderFind;
class LadderQueryResult;
class VirtualBuffer;
class PacketBuffer;
class DynamicBuffer;
union UserAttributes;
class UserIdentity;
class UserGroup;
class AccessManager;
struct D2UserInfo;
struct MapInfo;
template <typename T> class AccessManagerList;
typedef AccessManagerList<UserGroup> AccessManagerListG;
typedef AccessManagerList<UserIdentity> AccessManagerListI;
//class AccessManager::NotFound;
//class AccessManager::AlreadyExists;
//class AccessManagerList;

// DLL main procedure definition
typedef BOOL (__stdcall DllMainProc)(HINSTANCE hinstdll, DWORD fdwReason, LPVOID lpvReserved);

// Dumphex output procedure definition
typedef void (__cdecl DumphexOutputProc)(void *Param, const char *pszFormat, ...);

// Decensor a string
extern void decensor(char *txt);

// Send a Battle.net binary packet
extern bool sendpacket(SOCKET sendsocket, char id, VirtualBuffer &sendbuf);

// Receive a Battle.net binary packet
extern void receivepacket(const unsigned char *streambuffer, VirtualBuffer &recvbuf);

// Convert a string into hex-chat format (includes hexchat header)
extern void hex(const char *txt, char *output);

// Convert a string into plain-text format from hex-chat format (exclude hexchat header)
extern void dehex(const char *txt, char *output);

// Encrypt a string using the DMEncrypt standard (does  not include header DMEncrypt)
extern void encrypt(const char *source, char *output);

// Decrypt a string using the DMEncrypt standard (exclude DMEncrypt header)
extern void decrypt(const char *source, char *dest);

// Determine if a string could be encrypted using the Adron RSA/3DES Encryption standard
extern bool isencryptedtext(const char *txt);

// Get the title and current difficulty of a Diablo II user as a string
extern const char* GetTitleAndCurrentDifficulty(int currentdifficulty, int bosseskilled, bool female, bool hardcore, bool expansion, const char** difficultystr = NULL);

// Format a string with extended title information about a character
extern void GetCharacterFullTitle(char* buf, const char* charactername, int actsfinished, bool female, bool hardcore, bool expansion);

// Parse the statstring of any Battle.net product
extern void parsestatstring(const char *teststatstring, char *statbuf);

// Get information about a Diablo II/Lord of Destruction user
extern bool GetD2Stats(const char *pszStatstring, D2UserInfo *pInfo);

// Get information about a Starcraft/Brood War/Japan Starcraft/Warcraft II: BNE game
extern bool GetMapInfo(const char *pszMapStatstring, MapInfo *pInfo);

// Display hex and ascii data of a buffer, to the console or to a file
extern void dumphex(const char *buf, int len, int pos);
extern void dumphex(FILE *f, const char *buf, int len, int pos);
extern void dumphex(const char *buf, int len, int pos, DumphexOutputProc *pOutputProc, void *Param);

// Encrypt a function at run-time
extern void encryptfunction(void *function, bool recrypt = false);

// Decrypt a function at run-time
extern void decryptfunction(void *function);

// Scramble a function at run-time
extern void scramblefunction(void *pFunction);

// Descramble a function at run-time
extern void descramblefunction(void *pFunction);

// Optional checksum function used with "secure" encryption; implementation NOT provided!
extern unsigned long Checksum(const char *text);

// Wildcard matching function
extern int match(const char *text, const char *mask);

// Registry functions
extern bool getregstr(const char *path, const char *value, char *buffer, DWORD *len);
extern bool setregstr(const char *path, const char *value, const char *buffer);
extern bool setregstrhkcu(const char *path, const char *value, const char *buffer);
extern DWORD getregdw(const char *path, const char *value);
extern bool setregdw(const char *path, const char *value, DWORD buffer);
extern bool setregdwhkcu(const char *path, const char *value, DWORD buffer);

// Get entry-point function of a dll
extern DllMainProc *FindDllEntryPoint(HINSTANCE hDLL);

// Get the size of a module
extern DWORD GetModuleSize(HINSTANCE hModule);

// Get the code size of a module
extern DWORD GetModuleCodeSize(HINSTANCE hModule);

// Get the Initialized Data size of a module
extern DWORD GetModuleInitDataSize(HINSTANCE hModule);

// Get the Uninitialized Data size of a module
extern DWORD GetModuleUninitDataSize(HINSTANCE hModule);

// Get the virtual address of Initialized Data of a module
extern DWORD *GetModuleData(HINSTANCE hModule);

// Get the virtual address of Uninitialized Data of a module
extern DWORD *GetModuleUninitData(HINSTANCE hModule);

// Encrypted internal GetProcAddress implementation
extern FARPROC EGetProcedureAddress(HMODULE hModule, const char *pszProcedureName);

// Unencrypted internal GetProcAddress implementation
extern FARPROC UEGetProcedureAddress(HMODULE hModule, const char *pszProcedureName);

// Copy non-null-terminated strings, using the given terminators
extern char *strcpy(char *pszDest, const char *pszSource, char cSrcTerminator, char cDestTerminator = '\0');

// Allocate a string, and fill it with the contents of a given one
extern inline char *newstr(const char *psz);

//////////////////////////////////////////////////////////////////////////////////////////
// Classes
//////////

// Thread-safe counter class
class Counter {
public:
	Counter(DWORD startvalue = 0);
	~Counter();
	DWORD GetCounter(void);
	Counter &operator++(void);
	Counter &operator--(void);
	DWORD operator+(DWORD value);
	DWORD operator+(Counter &value);
	DWORD operator-(DWORD value);
	DWORD operator-(Counter &value);
	Counter &operator+=(DWORD value);
	Counter &operator+=(Counter &value);
	Counter &operator-=(DWORD value);
	Counter &operator-=(Counter &value);
	Counter &operator=(DWORD value);
	Counter &operator=(Counter &value);
	bool operator>(DWORD value);
	bool operator>(Counter &value);
	bool operator<(DWORD value);
	bool operator<(Counter &value);
	bool operator>=(DWORD value);
	bool operator>=(Counter &value);
	bool operator<=(DWORD value);
	bool operator<=(Counter &value);
	bool operator==(DWORD value);
	bool operator==(Counter &value);
	bool operator!=(DWORD value);
	bool operator!=(Counter &value);
	bool operator!(void);
	operator unsigned long(void);
private:
	DWORD counter;
	CRITICAL_SECTION critsec;
};

// Virtual base-class for buffering classes
class VirtualBuffer {
public:
	virtual ~VirtualBuffer(void) { }
	virtual void insert(unsigned long data) = 0;
	virtual void insert(const char *data) = 0;
	virtual void insert(const void *data, int size) = 0;
	virtual void insert(const LadderQuery &query) = 0;
	virtual void insert(const LadderFind &find) = 0;
	virtual void insertbyte(unsigned char data) = 0;
	virtual void insertshort(unsigned short data) = 0;
	virtual unsigned long extract(void) = 0;
	virtual char *extract(char *databuf) = 0;
	virtual unsigned char extractbyte(void) = 0;
	virtual unsigned short extractshort(void) = 0;
	virtual void *extract(void *databuf, int size) = 0;
	virtual LadderQueryResult &extract(LadderQueryResult &query) = 0;
	virtual unsigned short extractlen(void) = 0;
	virtual short extractepos(void) = 0;
	virtual short extractipos(void) = 0;
	virtual void clear(void) = 0;
	virtual void resetextraction(void) = 0;
	virtual void resetinsertion(void) = 0;
	virtual void reset(void) = 0;
	virtual operator char *(void) = 0;
	virtual operator int(void) = 0;
	virtual operator +=(int size) = 0;
	virtual operator -=(int size) = 0;
};

// Fixed-size buffer class
class PacketBuffer : public VirtualBuffer {
public:
	PacketBuffer(const PacketBuffer &srcbuf);
	PacketBuffer(void);
	virtual ~PacketBuffer();
	virtual void insert(unsigned long data);
	virtual void insert(const char *data);
	virtual void insert(const void *data, int size);
	virtual void insert(const LadderQuery &query);
	virtual void insert(const LadderFind &find);
	virtual void insertbyte(unsigned char data);
	virtual void insertshort(unsigned short data);
	virtual unsigned long extract(void);
	virtual char *extract(char *databuf);
	virtual unsigned char extractbyte(void);
	virtual unsigned short extractshort(void);
	virtual void *extract(void *databuf, int size);
	virtual LadderQueryResult &extract(LadderQueryResult &query);
	virtual unsigned short extractlen(void);
	virtual short extractepos(void);
	virtual short extractipos(void);
	virtual void clear(void);
	virtual void resetextraction(void);
	virtual void resetinsertion(void);
	virtual void reset(void);
	virtual operator char *(void);
	virtual operator int(void);
	virtual operator +=(int size);
	virtual operator -=(int size);
	friend DynamicBuffer;
private:
	//char buffer[16384];
	char buffer[16792];
	short len;
	short ipos;
	short epos;
};

// Dynamically-allocated buffer class
class DynamicBuffer : public VirtualBuffer {
public:
	DynamicBuffer(const DynamicBuffer &dbSource, unsigned long _ulTargetSize = DynamicBuffer::TargetSize);
	DynamicBuffer(const PacketBuffer &pbSource, unsigned long _ulTargetSize = DynamicBuffer::TargetSize);
	DynamicBuffer(unsigned long _ulTargetSize = DynamicBuffer::TargetSize);
	virtual ~DynamicBuffer(void);
	virtual void insert(unsigned long data);
	virtual void insert(const char *data);
	virtual void insert(const void *data, int size);
	virtual void insert(const LadderQuery &query);
	virtual void insert(const LadderFind &find);
	virtual void insertbyte(unsigned char data);
	virtual void insertshort(unsigned short data);
	virtual unsigned long extract(void);
	virtual char *extract(char *databuf);
	virtual unsigned char extractbyte(void);
	virtual unsigned short extractshort(void);
	virtual void *extract(void *databuf, int size);
	virtual LadderQueryResult &extract(LadderQueryResult &query);
	virtual unsigned short extractlen(void);
	virtual short extractepos(void);
	virtual short extractipos(void);
	virtual void clear(void);
	virtual void resetextraction(void);
	virtual void resetinsertion(void);
	virtual void reset(void);
	virtual operator char *(void);
	virtual operator int(void);
	virtual operator +=(int size);
	virtual operator -=(int size);

	virtual unsigned long size(void) { return ulCurrentSize; }

	static const unsigned long TargetSize;
private:
	void resize(unsigned long ulNewSize);
	//char buffer[16384];
	char *buffer;
	unsigned long len;
	unsigned long ipos;
	unsigned long epos;
	unsigned long ulTargetSize;
	unsigned long ulCurrentSize;
};

// Class to store profile requests, to be looked up on receiving profile data
class ProfileIndex {
public:
	ProfileIndex(int _numaccounts, int _numkeys, int _queryid, const char *_queryuser = 0);
	~ProfileIndex();
	bool AddAccount(const char *accountname);
	bool AddKey(const char *keyname);
	void ResetIndex(void);
	void SetValue(void *pNewValue) { pValue = pNewValue; }
	void *GetValue(void) { return pValue; }
	char *GetAccount(char *accountbuf);
	const char *PeekAccount(void);
	char *GetKey(char *keybuf);
	int GetQueryId(void);
	const char *GetQueryUser(void);
private:
	int numaccounts;
	int numkeys;
	int queryid;
	char **accountdatabase;
	char **keydatabase;
	char *queryuser;
	int accountpos;
	int keypos;
	int keyaccountpos;
	void *pValue;
};

// Diablo II/Lord of Destruction user info structure
struct D2UserInfo {
	const char *pszTitle, *pszDifficulty, *pszClass;
	char szCharacterName[26];
	bool bFemale, bHardcore, bDead, bExpansion;
	int iVersion, iLevel;
};

// Starcraft/Brood War/Japan Starcraft/Warcraft II BNE map/game info structure
struct MapInfo {
	char szMapName[256], szCreatorName[256];
	const char *pszMapType, *pszGameSpeed, *pszGameType;
	DWORD dwMapType, dwGameSpeed, dwGameType, dwGameTypeParam;

	enum {
		Standard				=	0x00000001,
		Blizzard_Approved		=	0x00000002,
		Ladder_Approved			=	0x00000003,
		KBK_Approved			=	0x00000004
	};

	enum {
		Slowest					=	0x00000001,
		Slower					=	0x00000002,
		Slow					=	0x00000003,
		Normal					=	0x00000004,
		Fast					=	0x00000005,
		Faster					=	0x00000006,
		Fastest					=	0x00000007
	};

	enum {
		Melee					=	0x00000002,
		Free_For_All			=	0x00000003,
		One_On_One				=	0x00000004,
		Capture_The_Flag		=	0x00000005,
		Greed					=	0x00000006,
		Slaughter				=	0x00000007,
		Sudden_Death			=	0x00000008,
		Ladder					=	0x00000009,
		Use_Map_Settings		=	0x0000000a,
		Team_Melee				=	0x0000000b,
		Team_Free_For_All		=	0x0000000c,
		Team_Capture_The_Flag	=	0x0000000d,
		Top_Vs_Bottom			=	0x0000000f
	};
};

// Abstract binary bot class
class BinaryBot {
public:
	BinaryBot(SOCKET *_bnetsocket, HANDLE _DataEvent, const char *_username, const char *_password, const char *_cdkey, DWORD _serverip, DWORD _socksip, bool _spawn = true);
	virtual ~BinaryBot();
	bool Connect(int connectiontype = SOCKS5);
	void Disconnect(void);
	bool SendStartup(void);
	bool SendVersionCheck(void);
	bool SendCDkey(void);
	bool SendLogon(void);
	bool CreateAccount(void);
	bool SendStats(void);
	bool JoinChannel(const char *channel);
	int DispatchEvent(void);
	unsigned long QueryServerAddress(void);
	unsigned long QuerySocksAddress(void);
	bool Idle(void);
	bool IsConnected(void);
	bool IsLoggedOn(void);
	enum {
		DISCONNECTED,
		CONNECTING,
		WAIT,
		CONNECTED,
		SENDSTARTUP,
		SENDVERSIONCHECK,
		SENDCDKEY,
		LOGON,
		CREATEACCOUNT,
		SENDSTATS,
		LOGGEDON
	};
	enum {
		FAILED,
		INCONCLUSIVE,
		VALID
	};
	enum {
		SOCKS4,
		SOCKS5,
		PLAIN
	};
	enum {
		STARTSOCKS,
		SENDSOCKSAUTH,
		SENDSOCKSCONNECT
	};
protected:
	int Socks5Connect(void);
	int Socks4Connect(void);
	int PlainConnect(void);
	int OpenSocks4Connection(void);
	bool CheckRevision(const char *ExecutablePath, const char *GeneralLibraryPath, const char *NetworkProviderPath, const char *Formula, unsigned long ChecksumSeedIndex, unsigned long *ExecutableVersion, unsigned long *Checksum, char *FileInfo);
	void datahash(unsigned long *param);
	void calchashbuf(unsigned long *hash, void *inbuf, int len);
	virtual int ProcessData(void);
	static BOOL DecodeCDKey(LPCTSTR lpszCDKey, DWORD *lpdwProductId, DWORD *lpdwValue1, DWORD *lpdwValue2);
	static BOOL DecodeStarcraftKey(LPSTR key);
	static BOOL DecodeD2Key(LPSTR key);
	static char Get_Hex_Value(DWORD v);
	static int Get_Num_Value(char c);
	virtual const int GetVersionByte(void) = 0;
	virtual const char *GetPlatformId(void) = 0;
	virtual const char *GetExecutableName(void) = 0;
	virtual const char *GetBattleName(void) = 0;
	virtual const char *GetStormName(void) = 0;
	// Virtual packet handlers
	virtual int OnIdle(int laststate); // 0x00
	virtual int OnServerList(int laststate); // 0x04
	virtual int OnAccountNumber(int laststate); // 0x05
	virtual int OnHashData(int laststate); // 0x06
	virtual int OnVersionCheckResult(int laststate); // 0x07
	virtual int OnOldGameStatus(int laststate); // 0x08
	virtual int OnGameListing(int laststate); // 0x09
	virtual int OnStats(int laststate); // 0x0a
	virtual int OnChannelList(int laststate); // 0x0b
	virtual int OnChannelEvent(int laststate); // 0x0f
	virtual int OnCloseConnection(int laststate); // 0x13
	virtual int OnAdbanner(int laststate); // 0x15
	virtual int OnMessage(int laststate); // 0x19
	virtual int OnOldGameCreate(int laststate); // 0x1a
	virtual int OnGameStatus(int laststate); // 0x1c
	virtual int OnRandomHashValues(int laststate); // 0x1d
	virtual int OnPing(int laststate); // 0x25
	virtual int OnProfile(int laststate); // 0x26
	virtual int OnOldRandomHashValues(int laststate); // 0x28
	virtual int OnLogon(int laststate); // 0x29
	virtual int OnCreateAccount(int laststate); // 0x2a
	virtual int OnIconsInfo(int laststate); // 0x2d
	virtual int OnLadderListing(int laststate); // 0x2e
	virtual int OnLadderSearch(int laststate); // 0x2f
	virtual int OnOldCDkey(int laststate); // 0x30
	virtual int OnPasswordChange(int laststate); // 0x31
	virtual int OnMapChecksums(int laststate); // 0x32
	virtual int OnFileTime(int laststate); // 0x33
	virtual int OnCDkey(int laststate); // 0x36
	virtual int OnUnknownPacket(int laststate, unsigned char packetid); // ??
	virtual int OnPreProcessPacket(int laststate, unsigned char packetid); // before processing
	virtual int OnPostProcessPacket(int laststate, unsigned char packetid); // after processing
	// Virtual channel event handlers
	virtual int OnInChannel(int laststate, const char *username, const char *statstring, unsigned long flags, unsigned long ping); // 1
	virtual int OnJoinChannel(int laststate, const char *username, const char *statstring, unsigned long flags, unsigned long ping); // 2
	virtual int OnLeaveChannel(int laststate, const char *username, unsigned long ping); // 3
	virtual int OnWhisperFrom(int laststate, const char *username, const char *text, unsigned long flags, unsigned long ping); // 4
	virtual int OnTalk(int laststate, const char *username, const char *text, unsigned long flags, unsigned long ping); // 5
	virtual int OnBroadcast(int laststate, const char *username, const char *text, unsigned long flags, unsigned long ping); // 6
	virtual int OnEnterChannel(int laststate, const char *channelname, unsigned long channelflags, unsigned long selfping); // 7
	virtual int OnStatusUpdate(int laststate, const char *username, const char *statstring, unsigned long flags, unsigned long ping); // 9
	virtual int OnWhisperTo(int laststate, const char *username, const char *text, unsigned long flags, unsigned long ping); // 10
	virtual int OnChannelFull(int laststate, const char *channelname); // 13
	virtual int OnChannelEmpty(int laststate, const char *channelname); // 14
	virtual int OnChannelRestricted(int laststate, const char *channelname); // 15
	virtual int OnInfo(int laststate, const char *text); // 18
	virtual int OnError(int laststate, const char *text); // 19
	virtual int OnEmote(int laststate, const char *username, const char *text, unsigned long flags, unsigned long ping); // 23
	virtual int OnUnknownChannelEvent(int laststate, unsigned char eventid, const char *username, const char *text, unsigned long flags, unsigned long ping); // ??
	// Variables
	SOCKET *bnetsocket;
	PacketBuffer sendbuf;
	PacketBuffer recvbuf;
	HANDLE DataEvent;
	DWORD serverip;
	DWORD socksip;
	char *username;
	char *password;
	char *cdkey;
	bool spawn;
	int serverpos;
	int sockspos;
	int state;
	int dllnumber;
	int sockstype;
	int socksstate;
	int adinfo;
	char hashcommand[255];
	unsigned char databuf[4049];
	int buflen;
	int serverencryptvalue;
	static unsigned long classcount;
	static unsigned char codevalues[256];
/*	static const char *platformid;
	static const char *executablename;
	static const char *battlename;
	static const char *stormname;*/
};

// User attribute data type (32 bits)
union UserAttributes {
	struct {
		// Privileges
		unsigned A : 1;
		unsigned B : 1;
		unsigned C : 1;
		unsigned D : 1;
		unsigned E : 1;
		unsigned F : 1;
		unsigned G : 1;
		unsigned H : 1;
		unsigned I : 1;
		unsigned J : 1;
		unsigned K : 1;
		unsigned L : 1;
		unsigned M : 1;
		unsigned N : 1;
		unsigned O : 1;
		unsigned P : 1;
		unsigned Q : 1;
		unsigned R : 1;
		unsigned S : 1;
		unsigned T : 1;
		unsigned U : 1;
		unsigned V : 1;
		unsigned W : 1;
		unsigned X : 1;
		unsigned Y : 1;
		unsigned Z : 1; // 26
		// Other information
		unsigned Designated : 1;
		unsigned Operator : 1; // 28
		unsigned Reserved : 4; // 32
	};
	struct {
		unsigned Attributes : 26; // 26
		unsigned Information : 6; // 32
	};
	inline void Set(unsigned char cAttribute)
	{
		if(cAttribute < 'A' || cAttribute > 'Z')
			return;
		dwFlags |= (1 << (cAttribute - 'A'));
	}
	inline void Set(UserAttributes _Attributes)
	{
		Attributes |= _Attributes.Attributes;
	}
	inline void Remove(unsigned char cAttribute)
	{
		if(cAttribute < 'A' || cAttribute > 'Z')
			return;
		dwFlags &= ~(1 << (cAttribute - 'A'));
	}
	inline void Remove(UserAttributes _Attributes)
	{
		Attributes &= ~_Attributes.Attributes;
	}
	inline bool Check(unsigned char cAttribute) const
	{
		if(cAttribute < 'A' || cAttribute > 'Z')
			return false;
		return !!(dwFlags & (1 << (cAttribute - 'A'))); // ~~~ not 'a' gddmit ~~~
	}
	inline bool Check(UserAttributes _Attributes) const
	{
		return (Attributes & _Attributes.Attributes) == _Attributes.Attributes;
	}
	inline void Replace(UserAttributes _Attributes, bool bReplaceInformation)
	{
		if(bReplaceInformation)
			dwFlags = _Attributes.dwFlags;
		else
			Attributes = _Attributes.Attributes;
	}
	DWORD dwFlags; // 32
};/*

// User alias name
class Named
{
private:
	const std::string m_Name;
	
public:
	std::string GetName() const;
	
	Named(std::string Name)
		: m_Name(Name) {}
};

// Containing group
class ContainedByGroup
{
private:
	UserGroup* const m_ContainingGroup; // 0 if no such group
	
public:
	UserGroup* GetContainingGroup() const;
	
	ContainedByGroup(UserGroup* ContainingGroup)
		: m_ContainingGroup(ContainingGroup) {}
};

// Access-manager exceptions
class AccessManagerExceptions
{
public:
	class AlreadyExists {};
	class NotFound {};
};

// Accesslist management class
class AccessManager
{
public:
	UserGroup AddGroup(std::string GroupName) throw(AccessManagerExceptions::AlreadyExists);
		// Creates a new group and adds it to the list.
	
	void RemoveGroup(std::string GroupName) throw();
		// Removes a group and all the subgroups and users contained in it.
	
	std::list<UserGroup> GetGroups(bool IncludeSubGroups = false) const throw();
		// Returns a list of the contained groups.
	
	UserGroup FindGroupByName(std::string GroupName, bool SearchSubGroups = false) const throw(AccessManagerExceptions::NotFound);
		// Locates a contained group by its name.
	
	UserIdentity AddUser(std::string UserName) throw(AccessManagerExceptions::AlreadyExists);
		// Creates a new user and adds it to the list.
	
	void RemoveUser(std::string UserName) throw();
		// Removes a user from the group.
	
	std::list<UserIdentity> GetUsers(bool IncludeSubGroups = true) const throw();
		// Returns a list of the contained users.
	
	UserIdentity FindUserByName(std::string Name, bool SearchSubGroups = true) const throw(AccessManagerExceptions::NotFound);
		// Locates a user by its name.
	
	virtual std::list<UserIdentity> FindUsersByAttributes(UserAttributes Attributes, bool SearchSubGroups = true) const throw();
		// Returns list of users who have *all* the requested attributes.
	
private:
	AccessManagerListG Groups;
	AccessManagerListI Users;
};

// User identity class
class UserIdentity : public Named, public ContainedByGroup
{
	friend AccessManager;
	
public:
	UserAttributes Attributes; // The user's attributes.
	
	std::list<std::string> GetAliases() const throw();
		// Returns a list of the user's aliases.
	
	void AddAlias(std::string Alias) throw();
		// Adds an alias.
	
	void RemoveAlias(std::string Alias) throw();
		// Removes an alias.
	
private:
	UserIdentity(std::string Name, UserGroup* Container) : Named(Name), ContainedByGroup(Container) {}
	std::list<std::string> m_Aliases;
};

// User group class
class UserGroup : public AccessManager, public Named, public ContainedByGroup
{
	friend AccessManager;
	
public:
	UserAttributes GroupAttributes; // The group's attributes.
	std::list<UserIdentity> FindUsersByAttributes(UserAttributes Attributes, bool SearchSubGroups = true) const throw();
	
private:
	UserGroup(std::string Name, UserGroup* Container) : Named(Name), ContainedByGroup(Container) {}
};

// Templated access manager list
template <typename T>
class AccessManagerList : public std::list<T>
{
	friend AccessManager;
	
public:
	T FindByName(std::string Name) const throw(AccessManagerExceptions::NotFound);
	T Add(std::string Name) throw(AccessManagerExceptions::AlreadyExists);
	void Remove(std::string Name) throw();
	
private:
	AccessManagerList() {}
};*/

// VirtualBuffer-friendly ladder checking class
class LadderQuery {
public:
	LadderQuery(unsigned long _type = 'SEXP', int _sort = 0, int _startrank = 0, int _numplayers = 10, int _league = 1);
	~LadderQuery();
	unsigned long GetType(void);
	int GetSort(void);
	int GetStartRank(void);
	int GetNumPlayers(void);
	int Getleague(void);
	friend PacketBuffer;
	friend DynamicBuffer;
	friend VirtualBuffer;
private:
	unsigned long type;
	int sort;
	int startrank;
	int league;
	int numplayers;
};

// VirtualBuffer-friendly ladder searching class
class LadderFind {
public:
	LadderFind(const char *_username, unsigned long _type = 'SEXP', int _sort = 0, int _league = 1);
	~LadderFind();
	const char *GetName(void);
	unsigned long GetType(void);
	int GetSort(void);
	int GetLeague(void);
	friend PacketBuffer;
	friend DynamicBuffer;
	friend VirtualBuffer;
private:
	char *username;
	unsigned long type;
	int sort;
	int league;
};

// VirtualBuffer-friendly ladder check parser class
class LadderQueryResult {
public:
	LadderQueryResult(unsigned long _type, int _sort, int _startrank, int _numplayers);
	~LadderQueryResult();
	int FormatString(char *buffer, int formatmode);
	const unsigned long *GetUnknowns(void);
	friend PacketBuffer;
	friend DynamicBuffer;
	friend VirtualBuffer;
	enum {
		OFFICIAL,
		CURRENT,
		SUMMARY,
		FORMATOK,
		FORMATERROR
	};
	enum {
		RATING = 0,
		WINS = 2,
		GAMES = 3
	};
private:
	char username[16];
	unsigned long type;
	int sort, startrank, numplayers;
	unsigned long currentwins, currentlosses, currentdiscs, currentrating, currentrank;
	unsigned long officialwins, officiallosses, officialdiscs, officialrating, officialrank;
	unsigned long highestrating;
	unsigned long season;
	unsigned long unknowns[4];
	FILETIME currentlastgame, officiallastgame;
};

// Run-time encryption class
class EncryptedFunction {
public:
	__forceinline EncryptedFunction(void) {
		char *functionaddress;
		__asm {
			call label
			label:
			pop eax
			mov functionaddress, eax
		}
		ENCRYPT_THISFUNCTION_ADDRESS = functionaddress;
		decryptfunction(ENCRYPT_THISFUNCTION_ADDRESS);
		__asm { nop
			sub esp, 0x01
			add esp, 0x01
			nop
		}
	};
	__forceinline ~EncryptedFunction(void) {
		_asm {
			nop
			sub esp, 0x03
			add esp, 0x03
			nop
		}
		encryptfunction(ENCRYPT_THISFUNCTION_ADDRESS);
	}
private:
	char *ENCRYPT_THISFUNCTION_ADDRESS;
};

// Generic output class
class FormattedOutput {
public:
	virtual DWORD WriteEx(char color, const char *format, ...) = 0;
	enum {
		WHITE = 0,
		GRAY = 1,
		BLUE = 2,
		GREEN = 3,
		RED = 4,
		YELLOW = 5,
		PURPLE = 6,
		BLUEGREEN = 7,
		MIDBLUE = 8,
		DARKBLUE = 9,
		DARKGREEN = 10,
		DARKYELLOW = 11,
		DARKRED = 12,
		DARKPURPLE = 13
	};
};

// Window output class
class WindowOutput : virtual public FormattedOutput {
public:
	WindowOutput(HWND _hWindow) { hWindow = _hWindow; }
	virtual ~WindowOutput(void) { };
	virtual DWORD WriteEx(char color, const char *format, ...)
	{
		DWORD dwResult;
		va_list argptr;
		va_start(argptr, format);
		dwResult = WriteWindow(format, argptr);
		va_end(argptr);
		return dwResult;
	}
	virtual void Activate(void) { ShowWindow(hWindow, SW_SHOW); }
	virtual void SetTitle(const char *pszTitle) { SetWindowText(hWindow, pszTitle); }
	virtual HWND GetWindow(void) { return hWindow; }
	operator HWND(void) { return GetWindow(); }
protected:
	virtual DWORD WriteWindow(const char *format, va_list argptr)
	{
		char szBuffer[8192];
		wvsprintf(szBuffer, format, argptr);
		if(SetWindowText(hWindow, szBuffer))
			return strlen(szBuffer);
		else
			return 0;
	}
	HWND hWindow;
};

// Socket output class
class SocketOutput : virtual public FormattedOutput {
public:
	SocketOutput(void) { SetSocketOutput(0); }
	SocketOutput(SOCKET *_sSocket) { SetSocketOutput(_sSocket); }
	virtual ~SocketOutput(void) { };
	virtual DWORD WriteEx(char color, const char *format, ...)
	{
		DWORD dwResult;
		va_list argptr;
		va_start(argptr, format);
		dwResult = WriteTCP(format, argptr);
		va_end(argptr);
		return dwResult;
	}
	virtual void SetSocketOutput(SOCKET *_sSocket) { sSocket = _sSocket; }
	virtual operator SOCKET(void) { if(sSocket) return *sSocket; else return INVALID_SOCKET; }
protected:
	virtual DWORD WriteTCP(const char *format, va_list argptr)
	{
		DWORD dwResult;
		char tmpbuf[8192], outputbuf[8192];
		int i, len, outputpos;
		if(sSocket && *sSocket != INVALID_SOCKET) {
			outputpos = 0;
			if(argptr)
				wvsprintf(tmpbuf, format, argptr);
			else
				strcpy(tmpbuf, format);
			CharToOem(tmpbuf, tmpbuf);
			len = strlen(tmpbuf);
			for(i = 0; i < len; i++) {
				if(tmpbuf[i] != '\n') {
					outputbuf[outputpos++] = tmpbuf[i];
				} else {
					outputbuf[outputpos++] = '\r';
					outputbuf[outputpos++] = '\n';
				}
			}
			outputbuf[outputpos] = 0;
			if((dwResult = static_cast <DWORD> (send(*sSocket, outputbuf, strlen(outputbuf), 0))) != SOCKET_ERROR)
				return dwResult;
			else
				return 0;
		} else {
			return 0;
		}
	}
	SOCKET *sSocket;
};

// File output class
class FileOutput : virtual public FormattedOutput {
public:
	FileOutput(void) { fFile = 0; }
	FileOutput(FILE *_fFile) { fFile = 0; SetLog(_fFile); }
	virtual ~FileOutput(void) { }
	virtual DWORD WriteEx(char color, const char *format, ...)
	{
		DWORD dwResult;
		va_list argptr;
		va_start(argptr, format);
		dwResult = WriteLog(format, argptr);
		va_end(argptr);
		return dwResult;
	}
	virtual void SetLog(FILE *_fFile) { if(fFile) fclose(fFile); fFile = _fFile; }
	virtual operator FILE *(void) { return fFile; }
protected:
	virtual DWORD WriteLog(const char *format, va_list argptr)
	{
		DWORD dwResult;
		if(fFile) {
			if((static_cast <int> ((dwResult = static_cast <DWORD> (argptr ? vfprintf(fFile, format, argptr) : fprintf(fFile, "%s", format))))) < 0)
				dwResult = 0;
			fflush(fFile);
			return dwResult;
		} else {
			return 0;
		}
	}
	FILE *fFile;
};

#ifndef NO_CONSOLEOUTPUT
// Console, file, and socket output class
class ConsoleOutput {
public:
	ConsoleOutput(CRITICAL_SECTION *_Synchronize, bool createscreenbuffer = false, FILE *_log = 0);
	~ConsoleOutput(void);
	DWORD WriteEx(char color, const char *format, ...);
	void SetTitle(const char *title);
	char *GetTitle(char *buffer, DWORD size = 1024);
	void Activate(void);
	HWND GetWindow(void);
	void SetLog(FILE *_log);
	void SetSocketOutput(SOCKET *_tcpoutput);
	enum {
		WHITE = 0,
		GRAY = 1,
		BLUE = 2,
		GREEN = 3,
		RED = 4,
		YELLOW = 5,
		PURPLE = 6,
		BLUEGREEN = 7,
		MIDBLUE = 8,
		DARKBLUE = 9,
		DARKGREEN = 10,
		DARKYELLOW = 11,
		DARKRED = 12,
		DARKPURPLE = 13
	};
private:
	DWORD Write(const char *format, va_list argptr);
	void WriteLog(const char *format, va_list argptr);
	void WriteTCP(const char *format, va_list argptr);
	void SetColor(char color);
	HANDLE output;
	CRITICAL_SECTION *Synchronize;
	bool createdscreenbuffer;
	FILE *log;
	SOCKET *tcpoutput;
};
#endif

// Icons.bni reading class
#ifndef IconsBNI
class IconsBNI
{
private:
	DWORD m_NumIcons;
	DWORD m_IconWidth;
	DWORD m_IconHeight;
	HBITMAP m_IconStrip;
	HDC m_IconStripDC;

	struct IconRecord {
		DWORD IconID;
		bool IDIsUserFlag; // True: IconID is user flag (like 0x02).
			// False: IconID is client ID (like 'D2XP').
	}* m_Icons;

#include <pshpack1.h> // 1-byte structure alignment
	struct TGAHeader { // According to targa.pdf, by TrueVision
		BYTE IDLength; // 1
		BYTE ColorMapType; // 2
		BYTE ImageType; // 3

		struct {
			WORD FirstEntryIndex; // 4
			WORD ColorMapLength; // 6
			BYTE EntrySize; // 8
		} ColorMapSpecification;

		struct {
			WORD XOrigin; // 9
			WORD YOrigin; // 11
			WORD ImageWidth; // 13
			WORD ImageHeight; // 15
			BYTE BitsPerPixel; // 17
			BYTE ImageDescriptor; // 18
		} ImageSpecification;
	};
#include <poppack.h>

	int GetIconIndex(DWORD IconID, bool IDIsUserFlag) const;
	static int NextIndex(DWORD& CurX, DWORD& CurY, int& CurElement,
		DWORD ImageWidth, bool RightToLeft, bool TopToBottom);

public:
	class LoadingError {};

	IconsBNI(HANDLE IconFile, HDC CompatibleDC) throw(LoadingError);
	~IconsBNI();

	DWORD GetIconCount() const
		{ return m_NumIcons; }
	DWORD GetIconWidth() const
		{ return m_IconWidth; }
	DWORD GetIconHeight() const
		{ return m_IconHeight; }
	HDC GetIconStripDC() const
		{ return m_IconStripDC; }
	
	int IndexByUserFlag(DWORD UserFlag) const // Index on success, -1 on failure
		{ return UserFlag ? GetIconIndex(UserFlag, true) : -1; }
	int IndexByClientID(DWORD ClientID) const // Index on success, -1 on failure
		{ return ClientID ? GetIconIndex(ClientID, false) : -1; }
};

#pragma warning(default: 4290) // C++ Exception Specification ignored
#pragma warning(default: 4800) // 'int' : forcing value to bool 'true' or 'false' (performance warning)

class Bitmap
{
private:
	HBITMAP m_Bitmap;
	HDC m_DC;
	
public:
	Bitmap(HINSTANCE hInstance, HDC CompatibleDC, UINT BitmapResID);
	~Bitmap();
	
	operator HDC() const
		{ return m_DC; }
};
#endif

#pragma warning(disable:4284)

#ifndef NO_PATCH
// DLL relocation class
class Relocation {
	char *dll;
	char *func;
	DWORD base;
	DWORD offs;
	Relocation();
public:
	~Relocation() {};
	Relocation(char *ndll, char *nfunc, DWORD noffs) : dll(ndll), func(nfunc), offs(noffs) {};
	operator DWORD() {return base; };
	void Relocate();
};

typedef void (*relativefunc)();
typedef struct _TAGABSOLUTEFUNC *absolutefunc;

// Memory patch class
class Patch {
	char *orig;
	char *repl;
	char *offs;
	int len;
	Relocation *reloc;
public:
	~Patch();
	Patch(DWORD offset, char *replace, int l, Relocation *nreloc = 0);
	Patch(DWORD offset, relativefunc func, Relocation *nreloc = 0);
	Patch(DWORD offset, absolutefunc func, Relocation *nreloc = 0);
	Patch();
	int Apply(void);
	int Remove(void);
private:
	bool relocdata;
	bool enabled;
};
#endif

// Socket class
class Socket {
public:
	Socket(void) { s = socket(AF_INET, (_type = SOCK_STREAM), (_protocol = IPPROTO_TCP)); }
	Socket(int type) { s = socket(AF_INET, (_type = type), (_protocol = IPPROTO_TCP)); }
	Socket(int type, int protocol) { s = socket(AF_INET, (_type = type), (_protocol = protocol)); }
	Socket(SOCKET _s) { s = _s; }
	~Socket(void) { closesocket(s); }
	void Reset(void) { closesocket(s); s = socket(AF_INET, _type, _protocol); }
	operator SOCKET(void) { return s; }
private:
	int _type, _protocol;
	SOCKET s;
};

// TCP/IP connection class
class Connection {
public:
	Connection(unsigned long _ip, unsigned short _port) { s = 0; ip = _ip; port = _port; state = DISCONNECTED; }
	Connection(unsigned long _ip, unsigned short _port, Socket *sock) { s = sock; ip = _ip; port = _port; state = DISCONNECTED; }
	~Connection() { if(s) delete s; }
	bool Connect(void);
	void AsyncConnect(void);
	void AsyncConnectComplete(bool result);
	void Disconnect(void);
	int Receive(char *buffer, int maxlen);
	int Send(char *buffer, int len);
	bool EventSelect(HANDLE h, long events = 0);
	enum {
		DISCONNECTED,
		CONNECTING,
		CONNECTED
	};
	operator SOCKET(void);
	bool operator !(void);
private:
	Socket *s;
	unsigned long ip;
	unsigned short port;
	int state;
};

// Template linked list node
template <class T>
struct Listnode {
	T data;
	Listnode<T> *next;
};

// Template linked list class
template <class T>
class List {
public:
	operator T() { return get(); };
	T operator ->() { return get(); };
	T get();
	T getfirst();
	T takefirst();
	void operator++();
	void rewind();
	void add(T data);
	void addend(T data);
	void remove(T data);
	int at_end();
	int is_empty();
	int get_count();
	List();
	~List();
private:
	Listnode<T> *head;
	Listnode<T> *pos;
	Listnode<T> **tailp;
	int count;
};

// Template linked list interface class
template <class T>
class ListEx {
public:
	operator T() { return (T)TheList.get(); }
	T operator ->() { return operator T(); }
	T get() { return (T)TheList.get(); }
	T getfirst() { return (T)TheList.getfirst(); }
	T takefirst() { return (T)TheList.takefirst(); }
	void operator++() {TheList.operator++();}
	void rewind() { TheList.rewind(); }
	void add(T data) { TheList.add((void *)data); }
	void addend(T data) { TheList.addend((void *)data); }
	void remove(T data) { TheList.remove((void *)data); }
	int at_end() { return TheList.at_end(); }
	int is_empty() { return TheList.is_empty(); }
	int get_count() { return TheList.get_count(); }
private:
	List<void *> TheList;
};

#if 0
// Template linked list node (new)
template <class T>
struct LinkedListNode {
	T data;
	LinkedListNode<T> *next;
};

// Template linked list class (new)
template <class T>
class LinkedList {
public:
	LinkedList(void);
	~LinkedList(void);
	operator T(void);
	T operator ->(void) { return get(); }
	T get(void);
	T getfirst(void);
	T takefirst(void);
	T getlast(void);
	T takelast(void);
	void operator++(void);
	void rewind(void);
	void add(T data);
	void addend(T data);
	void remove(T data);
	void clear(void);
	int at_end(void);
	int is_empty(void);
	int get_count(void);
private:
	LinkedListNode<T> *head, **tailp, *pos;
	int count;
};
#endif

#pragma warning(default:4284)

// Abstract thread-synchronization base class
class lockable {
public:
	virtual void lock()=0;
	virtual void unlock()=0;
};

// Critical section class
class critical_section : public lockable {
public:
	void lock();
	void unlock();
	critical_section();
	critical_section(CRITICAL_SECTION *_critsec);
	~critical_section();
private:
	CRITICAL_SECTION *critsec;
	bool destroy;
};

// Mutex class
class mutex : public lockable {
public:
	void lock();
	void unlock();
	mutex();
	mutex(const char *name);
	~mutex();
private:
	HANDLE h;
};

// Memory protection class
class Protection {
public:
	Protection(void *_address, unsigned long _size, unsigned long mode = PAGE_EXECUTE_READWRITE);
	~Protection(void);
	unsigned long GetOldProtection(void);
private:
	void *address;
	unsigned long oldprotection, size;
};

// Memory locking class
class MemoryLock {
public:
	MemoryLock(void *_address, unsigned long _size);
	~MemoryLock(void);
private:
	void *address;
	unsigned long size;
};

// Automatic locking/unlocking mechanism for classes based on class lockable
class autolock {
public:
	autolock(lockable& init) : lockobj(init) { lockobj.lock(); };
	~autolock() { lockobj.unlock(); };
private:
	lockable& lockobj;
};

// Automatic Winsock startup/cleanup class
class WinsockInstance {
public:
	WinsockInstance(unsigned short version = 0x0202);
	~WinsockInstance(void);
	const WSADATA *GetWSAData(void);
private:
	WSADATA wsadata;
};

// Abstract automatic handle base class
class Handle {
public:
	Handle(HANDLE _hObject);
	virtual ~Handle();
	HANDLE GetHandle(void);
/*	virtual void Lock(void) { }; // Mutex/Semaphore only
	virtual void Unlock(void) { }; // Mutex/Semaphore only
	virtual void lock(void) { }; // Compatability with class lockable
	virtual void unlock(void) { }; // Compatability with class lockable
	virtual void Lock(unsigned long startpos, unsigned long size) { }; // File only
	virtual void Unlock(unsigned long startpos, unsigned long size) { }; // File only
	virtual void Set(void) { }; // Event only
	virtual void Reset(void) { }; // Event only
	virtual void Pulse(void) { }; // Event only
	virtual unsigned long Seek(unsigned long position, unsigned long movemode) { return 0; }; // File only
	virtual void SetEOF(void) { }; // File only
	virtual unsigned long Wait(unsigned long waittime) { return 0; }; // Event/Semaphore only
	virtual unsigned long GetSize(void) { return 0; }; // File only*/
	operator void *(void);
protected:
	HANDLE hObject;
};

// Automatic event class
class Event : public Handle {
public:
	Event(bool manualreset = false, bool startsignaled = false) : Handle(CreateEvent(0, manualreset == true ? 1 : 0, startsignaled == true ? 1 : 0, 0)) { };
	virtual ~Event(void) { };
	virtual void Set(void);
	virtual void Reset(void);
	virtual void Pulse(void);
	virtual unsigned long Wait(unsigned long waittime = INFINITE);
};

// Automatic semaphore class
class Semaphore : public Handle, public lockable {
public:
	Semaphore(long initialcount = 0, long maxcount = 100) : Handle(CreateSemaphore(0, initialcount, maxcount, 0)) { };
	virtual ~Semaphore(void) { };
//	virtual void Lock(void);
//	virtual void Unlock(void);
//	virtual void lock(void) { Lock(); };
//	virtual void unlock(void) { Unlock(); };
	virtual void lock(void);
	virtual void unlock(void);
};

// Automatic mutex class
class Mutex : public Handle, public lockable {
public:
	Mutex(const char *name = 0) : Handle(CreateMutex(0, 0, name)) { };
	Mutex(HANDLE hMutex) : Handle(hMutex) { };
	virtual ~Mutex(void) { };
//	virtual void Lock(void);
//	virtual void Unlock(void);
//	virtual void lock(void) { Lock(); };
//	virtual void unlock(void) { Unlock(); };
	virtual void lock(void);
	virtual void unlock(void);
	virtual unsigned long Wait(unsigned long waittime = INFINITE);
};

// Automatic file class
class File : public Handle {
public:
	File(const char *filename, unsigned long access = GENERIC_READ | GENERIC_WRITE, unsigned long createmode = CREATE_ALWAYS, unsigned long sharemode = FILE_SHARE_READ | FILE_SHARE_WRITE) : Handle(CreateFile(filename, access, sharemode, 0, createmode, FILE_ATTRIBUTE_NORMAL, 0)) { };
	virtual ~File(void) { };
	virtual void Lock(unsigned long startpos, unsigned long size);
	virtual void Unlock(unsigned long startpos, unsigned long size);
	virtual unsigned long GetSize(void);
	virtual unsigned long Seek(unsigned long position, unsigned long movemode = FILE_CURRENT);
	virtual void SetEOF(void);
};
/*
// Window exception class
class WindowException {
public:
	WindowException(DWORD _dwCode, const char *_pszDescription = 0);
	~WindowException(void);
	DWORD GetCode(void) const;
	const char *GetDescription(void) const;
private:
	DWORD dwCode;
	mutable char *pszDescription;
};

// Window class
class Window {
public:
	Window(DWORD dwStyle = 0, const char *pszClass = "EDIT", const char *pszName = "", int xPos = 0, int yPos = 0, int nWidth = 0, int nHeight = 0, HWND hParent = 0, HMENU hMenu = 0, HINSTANCE hInstance = GetModuleHandle(0), void *pData = 0);
	Window(HANDLE _hWindow);
	~Window(void);
	void GetName(char *pszNameBuffer);
	void GetText(char *pszTextBuffer, size_t sMaxLen = 512);
	int GetTextLength(void);
	HWND GetParent(void);
	LONG GetLong(int nIndex);
	void SetForeground(void);
	void SetParent(HWND hParent);
	void SetText(char *pszText);
	LONG SetLong(int nIndex, LONG dwNewLong);
	bool IsMinimized(void);
	bool IsUnicode(void);
	bool IsVisible(void);
	bool IsMaximized(void);
	bool Move(int xPos, int yPos, int nWidth, int nHeight, bool bRepaint = true);
	bool Show(int nCmdShow);
	virtual static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
private:
	HWND hWindow;
};
*/
//////////////////////////////////////////////////////////////////////////////////////////
// Variables
////////////

// Function encryption start/end signatures
extern char encryptstartsignature[];
extern char encryptendsignature[];
extern char scramblestartsignature[];
extern char scrambleendsignature[];

// Checksum used with "secure" encryption
extern unsigned long checksum;

#endif

